/*
 The function "replace_string" included in this program will replace all occurence 
 of a certain string by another one and the function "find_occurence" will count 
 the number of occurance of a string in another string. Unlike most string replacer 
 function,this one have a special feature that makes it possible to avoid buffer overflow. 
 If you like this code,please vote or it,or at list let me know what do you think of it.

 this code is copyrighted and has limited warranties.
 author: Gonzales Cenelia.
*/

#define AVOID_OVERFLOW
#include <iostream>
#include <cstring>
#include <windows.h>
using std::cout;
using std::endl;

void replace_string( char *buff, char *oldString, char *newString, char *destString, size_t destSize );
int find_occurence( char *buff, char *str );
void display_string( char *buff, char *str );
BOOL settextcolor( WORD color );

void main()
{
	// this is an example that shows how to use the function "replace_string"
	char buffer[1300] = {0};
	char destString[1300] = {0};
	cout << "Text before string replacement: \n" << endl;
	strcpy( buffer,
		"Neil Alden Andersson was born on August 5,1930 in Wapakoneta, Ohio. He holds a "
		"degree in aeronautical engineering from Purdue University and a masters degree "
		"in aerospace engineering from the University of Southern California. From 1949 "
		"to 1952, Andersson was a naval aviator. Upon leaving military service, he became "
		"a test pilot. While serving as a test pilot, he was chosen to be a member of the "
		"astronaut corps. Though he was on the backup crew of many previous flights, his "
		"first space flight occurred in 1966 aboard Gemini 8. During this flight, he and "
		"fellow astronaut David Scott successfully performed the first docking in space "
		"between two vehicles. In July of 1969, Neil Andersson was the commander of "
		"Apollo 11, America's first attempt to land a manned vehicle on the Moon. On July "
		"20, 1969 Commander Andersson and fellow astronaut Edwin Aldrin successfully " 
		"touched down on the lunar surface. As Andersson became the first person to touch "
		"the Moon's surface, he spoke the unforgettable phrase, \"That's one small step\" "
		"for man; one giant leap for mankind\". He and Aldrin explored the Moon's surface " 
		"for 2.5 hours. Andersson was awarded the Presidential Medal of Freedom in "
		"recognition of his accomplishments and his contributions to the space program."
      );
	display_string( buffer, "Andersson" );
	cout << endl << endl << endl;
	cout << "Text after string replacement: \n" << endl;
	replace_string( buffer, "Andersson", "Armstrong", destString, 1300 );
	display_string( destString, "Armstrong" );
	cout << endl;
}

// replace all occurance of a certain string by another string
void replace_string( char *buff, char *oldString, char *newString, char *destString, size_t destSize )
{
	if( !strstr( buff, oldString ) ) return;
	int len = strlen(oldString);
	int len2 = strlen(newString);
	if(!len2) len2 += 1;
	int pos = 0, size = strlen(buff);
#ifdef AVOID_OVERFLOW
	if( len < len2 )
	{
		int occ = find_occurence( buff, oldString );
		size += occ * ( len2 - len );
	}
	if( destSize < size ) 
	{
		fprintf( stderr, "to avoid possible buffer overflow,the "
						 "buffer size must be at list %d bytes\n", size );
		return;
	}
#endif
	char *bkp = ( char* )malloc( sizeof(char) * size );
    char *tmp = ( char* )malloc( sizeof(char) * size );
	char *pdest;
	if( !bkp || !tmp )
    {
        fputs( "<string replacer>: memory allocation has fail.", stderr );
        return;
    }
	strcpy( bkp, buff ); 
	tmp[0] = 0;
	while(1)
	{
		pdest = strstr( buff, oldString );
		if( pdest == NULL ) break;
		pos = pdest - buff;
		bkp[pos] = 0;
		strcat( bkp, newString );
		strcat( tmp, bkp );
		buff += pos + len;
		strcpy( bkp, buff );
	}
	strcat( tmp, buff );
	strcpy( destString, tmp );
	bkp = 0;
	tmp = 0;
	free( bkp );
	free( tmp );
}

// count the number of occurance of the 
// string "str" in the string "buff"
int find_occurence( char *buff, char *str )
{
	char *tmp = buff;
	char *pdest;
	int occ = 0, pos;
	int len = strlen(str);
	while(1)
	{
		pdest = strstr( tmp, str );
		if( !pdest ) break;
		pos = pdest - tmp;
		tmp += pos + len;
		occ++;
	}
	return occ;
}

BOOL settextcolor( WORD color )
{
	HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE); 
	BOOL rt = SetConsoleTextAttribute( hStdout, color );
	return rt;
}

void display_string( char *buff, char *str )
{
	unsigned short color[4] = {0x0001, 0x0002, 0x0004, 0x00070};
	char *tmp = buff;
	char *pdest;
	int i = 0, j = 0;
	int tmp_pos, pos = 0;
	int len = strlen(str);
	while( 1 )
	{
		pdest = strstr( tmp, str );
		if( !pdest ) { cout << tmp; break; }
		tmp_pos = pdest - tmp;
		pos += tmp_pos;
		while( i != pos ) { cout << buff[i]; i++; }
		settextcolor( color[3] );
        while( j != len )  { cout << buff[i+j]; j++; }
		i += j; j = 0; pos = i;
		settextcolor( color[0] | color[1] | color[2] );
		tmp += tmp_pos + len;
	}
}
